/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fedc.FEDCFileDescriptor;
import java.util.ArrayList;
import java.util.List;

public class CommonPaUtils {
    private static final String TRACE_MASKT = "XPACUTLT";
    private static final String TRACE_MASKF = "XPACUTLF";
    private static final String TRACE_MASKD = "XPACUTLD";

    public static void resolveFileList(List fileInputList, List fileOutputList) {
        Trace.trace(TRACE_MASKD, "--> resolveFileList");
        Object fullFileName = null;
        String priority = null;
        String type = null;
        if (fileInputList != null) {
            int inputLength = fileInputList.size();
            Trace.trace(TRACE_MASKD, "input list size is" + inputLength);
            int i = 0;
            while (i < inputLength) {
                String xmlFileName = ((FEDCFileDescriptor)fileInputList.get((int)i)).name;
                priority = ((FEDCFileDescriptor)fileInputList.get((int)i)).priority.trim().toLowerCase();
                type = ((FEDCFileDescriptor)fileInputList.get((int)i)).type.trim().toLowerCase();
                Trace.trace(TRACE_MASKD, "search for the path for " + xmlFileName);
                try {
                    String filePath;
                    String directory = ((FEDCFileDescriptor)fileInputList.get((int)i)).directory;
                    if (directory != null) {
                        Trace.trace(TRACE_MASKD, "check the directory");
                        if (directory.startsWith("/")) {
                            Trace.trace(TRACE_MASKD, "don't use dfc to look up the directory");
                            filePath = CommonPaUtils.getPath(directory);
                        } else {
                            Trace.trace(TRACE_MASKD, "use dfc");
                            filePath = BaseFileControl.getFilePath(directory);
                        }
                    } else if (xmlFileName.startsWith("/")) {
                        Trace.trace(TRACE_MASKD, "don't use dfc to look up the name");
                        filePath = CommonPaUtils.getPath(xmlFileName);
                        xmlFileName = CommonPaUtils.getName(xmlFileName);
                        Trace.trace(TRACE_MASKD, "the file path is " + filePath);
                    } else {
                        filePath = BaseFileControl.getFilePath(xmlFileName);
                    }
                    Trace.trace(TRACE_MASKD, "path is " + filePath);
                    ArrayList fileList = FileUtilities.getFileList(filePath, xmlFileName, true);
                    int resolvedFileCount = fileList.size();
                    Trace.trace(TRACE_MASKD, "got " + resolvedFileCount + " files that match");
                    int j = 0;
                    while (j < resolvedFileCount) {
                        String fileName = (String)fileList.get(j);
                        Trace.trace(TRACE_MASKD, "got a resolved filename of " + fileName);
                        FEDCFileDescriptor newFile = new FEDCFileDescriptor();
                        newFile.name = filePath + fileName;
                        newFile.type = type;
                        newFile.priority = priority;
                        fileOutputList.add(newFile);
                        ++j;
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKD, "got a exception");
                    Trace.trace(TRACE_MASKD, e);
                }
                ++i;
            }
        }
        Trace.trace(TRACE_MASKD, "<-- resolveFileList");
    }

    private static String getPath(String name) {
        String path = name;
        int i = name.lastIndexOf(47);
        if (i > 0) {
            path = name.substring(0, i + 1);
            Trace.trace(TRACE_MASKD, "to path is: " + path);
        }
        return path;
    }

    private static String getName(String name) {
        String path = name;
        int i = name.lastIndexOf(47);
        if (i > 0) {
            path = name.substring(i + 1);
            Trace.trace(TRACE_MASKD, "just the name is: " + path);
        }
        return path;
    }
}

